#define iGlobalTime u_Elapsed * 0.164
uniform sampler2D texture0;
varying vec4 gl_TexCoord[];
varying vec4 gl_Color;

const float blurSize = 1.5 / 1024.0;

void main(void)
{
   vec4 sum = vec4(0.0);

   vec4 vTexCoord = gl_TexCoord[0];
   sum += texture2D(texture0, vec2(vTexCoord.x - 4.0*blurSize, vTexCoord.y - 4.0*blurSize)) * 0.05;
   sum += texture2D(texture0, vec2(vTexCoord.x - 3.0*blurSize, vTexCoord.y - 3.0*blurSize)) * 0.09;
   sum += texture2D(texture0, vec2(vTexCoord.x - 2.0*blurSize, vTexCoord.y - 2.0*blurSize)) * 0.12;
   sum += texture2D(texture0, vec2(vTexCoord.x - blurSize, vTexCoord.y - blurSize)) * 0.15;
   sum += texture2D(texture0, vec2(vTexCoord.x, vTexCoord.y)) * 0.16;
   sum += texture2D(texture0, vec2(vTexCoord.x + blurSize, vTexCoord.y + blurSize)) * 0.15;
   sum += texture2D(texture0, vec2(vTexCoord.x + 2.0*blurSize, vTexCoord.y + 2.0*blurSize)) * 0.12;
   sum += texture2D(texture0, vec2(vTexCoord.x + 3.0*blurSize, vTexCoord.y + 3.0*blurSize)) * 0.09;
   sum += texture2D(texture0, vec2(vTexCoord.x + 4.0*blurSize, vTexCoord.y + 4.0*blurSize)) * 0.05;

   gl_FragColor = sum * gl_Color;
}
